var googleCategory;
var googleCountryExtension;

function init() {
window.resizeTo(280, 270);
	if (window.widget) {
    	widget.onshow = onshow;
   		widget.onhide = onhide;
   		
   		googleCategory = widget.preferenceForKey("category");
   		
   		if (typeof googleCategory == "undefined") {
   			googleCategory = "Web";
   			widget.setPreferenceForKey(googleCategory, "category");	
   		}		
   		   		
		var chosenCategory = document.getElementById("chosenCategory");
		chosenCategory.innerText = googleCategory;

		loadGoogleList();
   	}
}

function onshow() {

}

function onhide() {
	
}

function search() {
	var searchString = document.getElementById("searchField").value;
	var countrySelection = document.getElementById("countrySelection").value;
	
	var splittedArray = searchString.split(" ");
	var newSearchString = "";
	
	if (searchString.length == 0) return;
	
	newSearchString += splittedArray[0];
	for (i = 1; i < splittedArray.length; i++) {
		newSearchString += "+" + splittedArray[i];
	}
	
	var searchURL = "";
	
	switch (googleCategory) {
		case "Web":
			searchURL = "http://www.google."+countrySelection+"/search?q="+newSearchString+"&ie=UTF-8&oe=UTF-8";
		break;
		case "Images":
			searchURL = "http://images.google."+countrySelection+"/images?q="+newSearchString+"&ie=UTF-8&oe=UTF-8";
		break;
		case "Groups":
			searchURL = "http://groups.google."+countrySelection+"/groups?q="+newSearchString+"&ie=UTF-8&oe=UTF-8";
		break;
		case "News":
			searchURL = "http://news.google."+countrySelection+"/news?q="+newSearchString+"&ie=UTF-8&oe=UTF-8";
		break;
	}
	
	if (window.widget) {
		widget.openURL(searchURL);
	}
}

/* GUI Functions */

function popupMenuOver() {
	var popupMenu = document.getElementById("popupMenu");
	popupMenu.src = "Images/popupMenuOver.png";
}

function popupMenuOut() {
	var popupMenu = document.getElementById("popupMenu");
	popupMenu.src = "Images/popupMenu.png";
}

function handlePopupMenuList() {
	if (popupMenuList.style.display == "none")
		popupMenuList.style.display = "block";
	else
		popupMenuList.style.display = "none";
}

function categorySelected(element) {
	googleCategory = element.innerText;
	chosenCategory.innerText = googleCategory;
	
	handlePopupMenuList();
	
	widget.setPreferenceForKey(googleCategory, "category");	
}

function countryChanged(element) {
	widget.setPreferenceForKey(element.selectedIndex, "country");	
}

/* show/hide prefs */

function showPrefs() {
	var frontDiv = document.getElementById("front");
	var backDiv = document.getElementById("back");
	
	if (window.widget) {
		widget.prepareForTransition("ToBack");
		
		var countrySelection = document.getElementById("countrySelection");
		var index = widget.preferenceForKey("country");
		
		if (typeof index == "undefined")
			index = 0;
			
		countrySelection.selectedIndex = index;
	}
	
	frontDiv.style.display="none";
	backDiv.style.display="block";
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}

function hidePrefs() {
	var frontDiv = document.getElementById("front");
	var backDiv = document.getElementById("back");
		
	if (window.widget) {
		widget.prepareForTransition("ToFront");	
	}

	backDiv.style.display="none";
	frontDiv.style.display="block";
		
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}
/* GoogleList.plist I/O */

var xmlRequest;

function loadGoogleList() {
	xmlRequest = new XMLHttpRequest();
        	
    xmlRequest.onreadystatechange = processXMLRequest;
    xmlRequest.setRequestHeader("Cache-Control", "no-cache");
    xmlRequest.open("GET", "GoogleList.plist", true);
    xmlRequest.send(null);
}

function releaseXMLRequest() {
	if (xmlRequest != null) {
		xmlRequest.abort();
		xmlRequest = null;
	}
}

function processXMLRequest() {
    if (xmlRequest.readyState == 4) {
     	parseXMLDocument(xmlRequest.responseXML);
    }
}

function parseXMLDocument(xmlData) {
	var items = xmlData.getElementsByTagName("dict");
	
	var countryList = document.getElementById("countrySelection");
	for (var i=0; i < items.length; i++) {
		var name = items[i].getElementsByTagName("string")[1].firstChild.nodeValue;
		var extension = items[i].getElementsByTagName("string")[0].firstChild.nodeValue;
		countryList.innerHTML += "<option value=\""+extension+"\">"+name+"</option>";
	}
}